filmy = []
with open('filmy_2.csv', mode='tr', encoding='utf-8') as soubor:
    for řádka in soubor:
        filmy.append(
            řádka.rstrip('\n ').split(';')
        )

# řadicí funkce
# ~ vrací poslední prvek dat filmu, tedy tržbu (nyní už jako číslo!)
def fn(prvek):
    return int(
        prvek[-1].strip('$').replace(',', '_')
    )

# výpis seznamu filmů seřazený podle pravidla v řadicí funkci fn()
for film in sorted(filmy, key=fn):
    pořadí, název, rok, režisér, tržby = film
    print(f'{pořadí}) {název}\n\t({rok}, r. {režisér})\n\t{tržby}')
